/*
 * $Id: pgpKeySpec.h,v 1.4 2001/01/25 22:11:32 jeffc Exp $
 */

#ifndef Included_pgpKeySpec_h
#define PGP_KEYSPEC_h

#include "pgpUsuals.h"
#include "pgpContext.h"

PGP_BEGIN_C_DECLARATIONS

PGPKeySpec  *pgpKeySpecCreate(PGPEnv const *env);
PGPKeySpec  *pgpKeySpecCopy(PGPKeySpec const *ks);
void  pgpKeySpecDestroy(PGPKeySpec *ks);

PgpVersion	pgpKeySpecVersion(PGPKeySpec const *ks);
PGPUInt32	pgpKeySpecCreation(PGPKeySpec const *ks);
PGPUInt16	pgpKeySpecValidity(PGPKeySpec const *ks);
PGPByte		pgpKeySpecPkAlg(PGPKeySpec const *ks);
PGPUInt32	pgpKeySpecKeyflags(PGPKeySpec const *ks, PGPBoolean *fkeyflags);
PGPUInt32	pgpKeySpecKeyservPrefs(PGPKeySpec const *ks,
				PGPBoolean *fkeyservprefs);
PGPByte const *
pgpKeySpecPrefKeyserv( PGPKeySpec const *ks, PGPSize *length );
PGPByte const *
pgpKeySpecPrefAlgs( PGPKeySpec const *ks, PGPSize *length );


int  pgpKeySpecSetVersion(PGPKeySpec *ks, PgpVersion ver);
int  pgpKeySpecSetCreation(PGPKeySpec *ks, PGPUInt32 creation);
int  pgpKeySpecSetValidity(PGPKeySpec *ks, PGPUInt16 validity);
int  pgpKeySpecSetPkAlg(PGPKeySpec *ks, PGPByte pkalg);
int  pgpKeySpecSetKeyflags(PGPKeySpec *ks, PGPUInt32 keyflags);
int  pgpKeySpecSetKeyservPrefs(PGPKeySpec *ks, PGPUInt32 keyservprefs);
int  pgpKeySpecSetPrefKeyserv(PGPKeySpec *ks, PGPByte const *prefkeyserv,
					PGPSize prefkeyservLength );
int  pgpKeySpecSetPrefAlgs(PGPKeySpec *ks, PGPByte const *prefalgs,
					PGPSize prefalgsLength );


PGPError pgpKeySpecFlatten( PGPKeySpec const *ks, PGPByte **pbuf,
							PGPSize *plen );
PGPKeySpec *pgpKeySpecFromBuf( PGPContextRef context, PGPByte const *buf,
							   PGPSize len, PGPError *err );

PGP_END_C_DECLARATIONS

#endif /* Included_pgpKeySpec_h */
